####################
# ## PARAMETERS ## #
####################

config = {
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-uscentral1',
  "exp_name": 'celeb_a_shortrun_test',
  "exp_dir": 'tfrc_out/fid',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',
  # number of gpus if using gpu device
  #'num_gpus': 1,

  # exp params
  "exp_type": "folder",
  "num_fid_rounds": 520,
  "batch_size": 96,
  "image_dims": [64, 64, 3],
  "split": "train",
  #"transform_type": "train",

  # ckpt folder
  #"ckpt_folder": 'gs://gen-tfrc-uscentral1/tfrc_out/celeb_a/nonconv_resnet_grad_100_21-09-03-04-00-37/checkpoints',
  #"epoch_freq": 5000,
  #"min_epoch": 60000,
  #"max_epoch": 60000,

  # data type and augmentation parameters
  "data_type": 'celeb_a',
 
  # ebm network
  "net_type": 'ebm_sngan',

  # langevin sampling parameters
  "mcmc_steps": 125,
  "epsilon": 3e-3,
  "mcmc_init": "coop",
  "mcmc_temp": 1e-6,
  # denoising parameters
  "grad_steps": 0,
  # clipping parameters
  "clip_langevin_grad": True,
  "max_langevin_norm": 0.25,

  "gen_type": "gen_sngan",
  "z_sz": 128,
  "fixed_gen": False
}
